﻿namespace Code6587EN.Ch02.ExportDesign
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Publishing;
    using System.Globalization;
    using System.IO;
    using System;

    /// <summary>
    /// Console Application to export a Design Package
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Get the Site Collection in a Using statement
            using (var site = new SPSite("http://sharepoint/sitecollection"))
            {
                // Get the root Site in a Using statement
                using (var web = site.RootWeb)
                {
                    // Create the Design Package
                    var package = DesignPackage.Export(site, "My Code Design", false);

                    // Create the File Name from the Package details
                    var fileName = string.Format(CultureInfo.InvariantCulture, "{0}-{1}.{2}.wsp", package.PackageName, package.MajorVersion, package.MinorVersion);

                    // Get the contents of the file
                    var fileBinary = web.GetFile("/_catalogs/solutions/" + fileName).OpenBinary();

                    // Write the file to the hard drive
                    var fileStream = new FileStream("C:\\Packages\\" + fileName, FileMode.OpenOrCreate, FileAccess.Write);
                    fileStream.Write(fileBinary, 0, fileBinary.Length);
                    fileStream.Close();
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
